/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.ICheckboxWidget;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IEntityTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IKeybindingButton;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorStatMoveScreen;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.KeybindingButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.entity_tracker.EntityTrackHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.BlockTrackerClientHandler;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public enum PneumaticHelmetRegistry implements IPneumaticHelmetRegistry
{
    INSTANCE;

    private static final Pair<BlockPos, Direction> NO_FOCUS;

    public static PneumaticHelmetRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerEntityTrackEntry(Supplier<? extends IEntityTrackEntry> entry) {
        EntityTrackHandler.getInstance().register(entry);
    }

    @Override
    public void registerBlockTrackEntry(ResourceLocation id, Supplier<? extends IBlockTrackEntry> entry) {
        BlockTrackHandler.getInstance().register(id, entry);
    }

    @Override
    public void addHUDMessage(Component title, List<Component> message, int duration, int backColor) {
        HUDHandler.getInstance().addMessage(title, message, duration, backColor);
    }

    @Override
    public void addHackable(Class<? extends Entity> entityClazz, Supplier<? extends IHackableEntity> iHackable) {
        CommonArmorRegistry.getInstance().addHackable(entityClazz, iHackable);
    }

    @Override
    public void addHackable(Block block, Supplier<? extends IHackableBlock> iHackable) {
        CommonArmorRegistry.getInstance().addHackable(block, iHackable);
    }

    @Override
    public void addHackable(TagKey<Block> blockTag, Supplier<? extends IHackableBlock> iHackable) {
        CommonArmorRegistry.getInstance().addHackable(blockTag, iHackable);
    }

    @Override
    public List<IHackableEntity> getCurrentEntityHacks(Entity entity) {
        return CommonArmorRegistry.getInstance().getCurrentEntityHacks(entity);
    }

    @Override
    public void registerUpgradeHandler(IArmorUpgradeHandler<?> handler) {
        CommonArmorRegistry.getInstance().registerUpgradeHandler(handler);
    }

    @Override
    public <T extends IArmorUpgradeHandler<?>> void registerRenderHandler(T handler, IArmorUpgradeClientHandler<T> clientHandler) {
        Validate.notNull(clientHandler, (String)"Render handler can't be null!", (Object[])new Object[0]);
        ArmorUpgradeClientRegistry.getInstance().registerHandler(handler, clientHandler);
    }

    @Override
    public IKeybindingButton makeKeybindingButton(int yPos, KeyMapping keyBinding) {
        return new KeybindingButton(30, yPos, 150, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.setKey", new Object[0]), keyBinding);
    }

    @Override
    public ICheckboxWidget makeKeybindingCheckBox(ResourceLocation upgradeId, int xPos, int yPos, int color, Consumer<ICheckboxWidget> onPressed) {
        return WidgetKeybindCheckBox.getOrCreate(upgradeId, xPos, yPos, color, onPressed);
    }

    @Override
    public IGuiAnimatedStat makeHUDStatPanel(Component title, ItemStack icon, IArmorUpgradeClientHandler<?> clientHandler) {
        StatPanelLayout layout = ArmorHUDLayout.INSTANCE.getLayoutFor(clientHandler.getID(), clientHandler.getDefaultStatLayout());
        return new WidgetAnimatedStat(null, title, WidgetAnimatedStat.StatIcon.of(icon), HUDHandler.getInstance().getStatOverlayColor(), null, layout);
    }

    @Override
    public IGuiAnimatedStat makeHUDStatPanel(Component title, ResourceLocation icon, IArmorUpgradeClientHandler<?> clientHandler) {
        StatPanelLayout layout = ArmorHUDLayout.INSTANCE.getLayoutFor(clientHandler.getID(), clientHandler.getDefaultStatLayout());
        return new WidgetAnimatedStat(null, title, WidgetAnimatedStat.StatIcon.of(icon), HUDHandler.getInstance().getStatOverlayColor(), null, layout);
    }

    @Override
    public AbstractWidget makeStatMoveButton(int x, int y, IArmorUpgradeClientHandler<?> handler) {
        return new WidgetButtonExtended(x, y, 150, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.moveStatScreen", new Object[0]), b -> Minecraft.m_91087_().m_91152_((Screen)new ArmorStatMoveScreen(handler)));
    }

    @Override
    public Pair<BlockPos, Direction> getBlockTrackerFocus() {
        if (!CommonArmorHandler.getHandlerForPlayer().upgradeUsable(CommonUpgradeHandlers.blockTrackerHandler, true)) {
            return NO_FOCUS;
        }
        BlockTrackerClientHandler handler = ArmorUpgradeClientRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.blockTrackerHandler, BlockTrackerClientHandler.class);
        return Pair.of((Object)handler.getFocusedPos(), (Object)handler.getFocusedFace());
    }

    static {
        NO_FOCUS = Pair.of(null, null);
    }
}

